/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authtoken;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Parser;
import com.floragunn.codova.documents.patch.PatchableDocument;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidatingFunction;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.ValidationResult;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.codova.validation.errors.MissingAttribute;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.searchguard.authtoken.RequestedPrivileges;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import java.time.temporal.TemporalAmount;
import java.util.Arrays;
import java.util.List;
import org.apache.cxf.rs.security.jose.common.JoseUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;
import org.apache.cxf.rs.security.jose.jwk.KeyType;
import org.apache.cxf.rs.security.jose.jwk.PublicKeyUse;

public class AuthTokenServiceConfig
implements PatchableDocument<AuthTokenServiceConfig> {
    public static CType<AuthTokenServiceConfig> TYPE = new CType("auth_token_service", "Auth Token Service", 10021, AuthTokenServiceConfig.class, AuthTokenServiceConfig::parse, CType.Storage.OPTIONAL, CType.Arity.SINGLE);
    public static final String DEFAULT_AUDIENCE = "searchguard_tokenauth";
    private boolean enabled;
    private JsonWebKey jwtSigningKey;
    private JsonWebKey jwtEncryptionKey;
    private String jwtAud;
    private TemporalAmount maxValidity;
    private List<String> excludeClusterPermissions = Arrays.asList("cluster:admin:searchguard:authtoken/_own/create");
    private List<RequestedPrivileges.ExcludedIndexPermissions> excludeIndexPermissions;
    private int maxTokensPerUser = 100;
    private FreezePrivileges freezePrivileges = FreezePrivileges.USER_CHOOSES;
    private DocNode source;
    private static final ValidatingFunction<DocNode, JsonWebKey> JWK_SIGNING_KEY_PARSER = new ValidatingFunction<DocNode, JsonWebKey>(){

        public JsonWebKey apply(DocNode jsonNode) throws ConfigValidationException {
            String jwkJsonString = jsonNode.toJsonString();
            JsonWebKey result = JwkUtils.readJwkKey((String)jwkJsonString);
            PublicKeyUse publicKeyUse = result.getPublicKeyUse();
            if (publicKeyUse != null && publicKeyUse != PublicKeyUse.SIGN) {
                throw new ConfigValidationException((ValidationError)new InvalidAttributeValue("use", (Object)publicKeyUse, (Object)"The use claim must designate the JWK for signing"));
            }
            return result;
        }
    };
    private static final ValidatingFunction<DocNode, JsonWebKey> JWK_HS512_SIGNING_KEY_PARSER = new ValidatingFunction<DocNode, JsonWebKey>(){

        public JsonWebKey apply(DocNode jsonNode) throws ConfigValidationException {
            byte[] key;
            try {
                key = JoseUtils.decode((String)jsonNode.toString());
            }
            catch (Exception e) {
                throw new ConfigValidationException(new InvalidAttributeValue(null, (Object)e.getMessage(), (Object)"A Base64URL encoded HMAC512 key with at least 512 bit (64 bytes, 86 Base64 encoded characters)").cause((Throwable)e));
            }
            if (key.length < 64) {
                throw new ConfigValidationException((ValidationError)new InvalidAttributeValue(null, (Object)"The key contains less than 512 bit", (Object)"A Base64URL encoded HMAC512 key with at least 512 bit (64 bytes, 86 Base64 encoded characters)"));
            }
            JsonWebKey jwk = new JsonWebKey();
            jwk.setKeyType(KeyType.OCTET);
            jwk.setAlgorithm("HS512");
            jwk.setPublicKeyUse(PublicKeyUse.SIGN);
            jwk.setProperty("k", (Object)jsonNode.toString());
            return jwk;
        }
    };
    private static final ValidatingFunction<DocNode, JsonWebKey> JWK_ENCRYPTION_KEY_PARSER = new ValidatingFunction<DocNode, JsonWebKey>(){

        public JsonWebKey apply(DocNode jsonNode) throws ConfigValidationException {
            String jwkJsonString = jsonNode.toJsonString();
            JsonWebKey result = JwkUtils.readJwkKey((String)jwkJsonString);
            PublicKeyUse publicKeyUse = result.getPublicKeyUse();
            if (publicKeyUse != null && publicKeyUse != PublicKeyUse.ENCRYPT) {
                throw new ConfigValidationException((ValidationError)new InvalidAttributeValue("use", (Object)publicKeyUse, (Object)"The use claim must designate the JWK for encryption"));
            }
            return result;
        }
    };
    private static final ValidatingFunction<DocNode, JsonWebKey> JWK_A256KW_ENCRYPTION_KEY_PARSER_A256KW = new ValidatingFunction<DocNode, JsonWebKey>(){

        public JsonWebKey apply(DocNode jsonNode) throws ConfigValidationException {
            byte[] key;
            String value = jsonNode.toString();
            try {
                key = JoseUtils.decode((String)value);
            }
            catch (Exception e) {
                throw new ConfigValidationException(new InvalidAttributeValue(null, (Object)e.getMessage(), (Object)"A Base64URL encoded A256KW key with at least 256 bit (32 bytes, 43 Base64 encoded characters)").cause((Throwable)e));
            }
            if (key.length < 32) {
                throw new ConfigValidationException((ValidationError)new InvalidAttributeValue(null, (Object)"The key contains less than 256 bit", (Object)"A Base64URL encoded A256KW key with at least 256 bit (32 bytes, 43 Base64 encoded characters)"));
            }
            JsonWebKey jwk = new JsonWebKey();
            jwk.setKeyType(KeyType.OCTET);
            jwk.setAlgorithm("A256KW");
            jwk.setPublicKeyUse(PublicKeyUse.ENCRYPT);
            jwk.setProperty("k", (Object)value);
            return jwk;
        }
    };

    public boolean isEnabled() {
        return this.enabled;
    }

    public JsonWebKey getJwtSigningKey() {
        return this.jwtSigningKey;
    }

    public JsonWebKey getJwtEncryptionKey() {
        return this.jwtEncryptionKey;
    }

    public String getJwtAud() {
        return this.jwtAud;
    }

    public TemporalAmount getMaxValidity() {
        return this.maxValidity;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setJwtSigningKey(JsonWebKey jwtSigningKey) {
        this.jwtSigningKey = jwtSigningKey;
    }

    public void setJwtEncryptionKey(JsonWebKey jwtEncryptionKey) {
        this.jwtEncryptionKey = jwtEncryptionKey;
    }

    public void setJwtAud(String jwtAud) {
        this.jwtAud = jwtAud;
    }

    public void setMaxValidity(TemporalAmount maxValidity) {
        this.maxValidity = maxValidity;
    }

    public List<String> getExcludeClusterPermissions() {
        return this.excludeClusterPermissions;
    }

    public void setExcludeClusterPermissions(List<String> excludeClusterPermissions) {
        this.excludeClusterPermissions = excludeClusterPermissions;
    }

    public List<RequestedPrivileges.ExcludedIndexPermissions> getExcludeIndexPermissions() {
        return this.excludeIndexPermissions;
    }

    public void setExcludeIndexPermissions(List<RequestedPrivileges.ExcludedIndexPermissions> excludeIndexPermissions) {
        this.excludeIndexPermissions = excludeIndexPermissions;
    }

    public static ValidationResult<AuthTokenServiceConfig> parse(DocNode jsonNode, Parser.Context context) {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vJsonNode = new ValidatingDocNode(jsonNode, validationErrors, context);
        AuthTokenServiceConfig result = new AuthTokenServiceConfig();
        result.source = jsonNode;
        result.enabled = vJsonNode.get("enabled").withDefault(false).asBoolean();
        if (result.enabled) {
            if (vJsonNode.hasNonNull("jwt_signing_key")) {
                result.jwtSigningKey = (JsonWebKey)vJsonNode.get("jwt_signing_key").by(JWK_SIGNING_KEY_PARSER);
            } else if (vJsonNode.hasNonNull("jwt_signing_key_hs512")) {
                result.jwtSigningKey = (JsonWebKey)vJsonNode.get("jwt_signing_key_hs512").by(JWK_HS512_SIGNING_KEY_PARSER);
            } else {
                validationErrors.add((ValidationError)new MissingAttribute("jwt_signing_key", (Object)jsonNode));
            }
            if (vJsonNode.hasNonNull("jwt_encryption_key")) {
                result.jwtEncryptionKey = (JsonWebKey)vJsonNode.get("jwt_encryption_key").by(JWK_ENCRYPTION_KEY_PARSER);
            } else if (vJsonNode.hasNonNull("jwt_encryption_key_a256kw")) {
                result.jwtEncryptionKey = (JsonWebKey)vJsonNode.get("jwt_encryption_key_a256kw").by(JWK_A256KW_ENCRYPTION_KEY_PARSER_A256KW);
            }
            result.jwtAud = vJsonNode.get("jwt_aud_claim").withDefault(DEFAULT_AUDIENCE).asString();
            result.maxValidity = vJsonNode.get("max_validity").asTemporalAmount();
            result.excludeClusterPermissions = vJsonNode.get("exclude_cluster_permissions").asList().withDefault(new String[]{"cluster:admin:searchguard:authtoken/_own/create"}).ofStrings();
            result.excludeIndexPermissions = vJsonNode.get("exclude_index_permissions").asList(RequestedPrivileges.ExcludedIndexPermissions::parse);
            result.maxTokensPerUser = vJsonNode.get("max_tokens_per_user").withDefault((Number)100).asInt();
            result.freezePrivileges = (FreezePrivileges)vJsonNode.get("freeze_privileges").withDefault((Enum)FreezePrivileges.USER_CHOOSES).asEnum(FreezePrivileges.class);
        }
        if (!validationErrors.hasErrors()) {
            return new ValidationResult((Object)result);
        }
        return new ValidationResult(validationErrors);
    }

    public int getMaxTokensPerUser() {
        return this.maxTokensPerUser;
    }

    public void setMaxTokensPerUser(int maxTokensPerUser) {
        this.maxTokensPerUser = maxTokensPerUser;
    }

    public FreezePrivileges getFreezePrivileges() {
        return this.freezePrivileges;
    }

    public void setFreezePrivileges(FreezePrivileges freezePrivileges) {
        this.freezePrivileges = freezePrivileges;
    }

    public Object toBasicObject() {
        return this.source;
    }

    public AuthTokenServiceConfig parseI(DocNode docNode, Parser.Context context) throws ConfigValidationException {
        return (AuthTokenServiceConfig)AuthTokenServiceConfig.parse(docNode, (Parser.Context)((ConfigurationRepository.Context)context)).get();
    }

    public static enum FreezePrivileges {
        ALWAYS,
        NEVER,
        USER_CHOOSES;

    }
}

